<?php
require_once '../resource/sessions.php';
require_once '../master_functions.php';
require_once '../db/Config.php';

$db = new Config();
$conn = $db->getConnection();

$currentmonth = date('Y-m');

$menu = '';
$sub_menu = 'pend-fba';


?>
<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>FBA OUT</title>
  <!-- plugins:css -->

  <?php require('../imports/importcss.php'); ?>
  <!-- End plugin css for this page -->
  <!-- inject:css -->
  <link rel="stylesheet" href="../assets/css/style.css">
  <!-- endinject -->

  <!--google chart-->
  <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>

  <link rel="stylesheet" href="../assets/css/datatable/dataTables.bootstrap5.min.css">
  <link href="https://cdn.datatables.net/1.13.2/css/jquery.dataTables.min.css" rel="stylesheet" type="text/css" />
  <link href="https://cdn.datatables.net/responsive/2.4.0/css/responsive.dataTables.min.css" rel="stylesheet" type="text/css" />
<link href="https://stackpath.bootstrapcdn.com/bootstrap/5.3.0/css/bootstrap.min.css" rel="stylesheet">
  <style>
    select.form-select {
      color: #252020 !important;
    }
  </style>
</head>

<body class="with-welcome-text">

  <div class="container-scroller">
    <!-- partial:partials/_navbar.html -->
    <?php require("../sections/header.php") ?>
    <!-- partial -->
    <div class="container-fluid page-body-wrapper">
      <!-- partial:partials/_sidebar.html -->
      <?php require("../sections/navbar.php") ?>

      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div class="card">
            <div class="card-header">
              <h5 class="fw-bold fs-4"><i class="mdi mdi-cube"></i>Outbound FBA</h5>
            </div>
            <div class="card-body shadow">
              <table class=" table table-striped" id="st-table" style="width: 100%;">
                <thead>
                  <tr>
                    <th  tabindex="0" aria-controls="example" rowspan="1" colspan="1" aria-sort="ascending" >VIEW</th>
                    <th class="sorting" tabindex="0" aria-controls="example" rowspan="1" colspan="1">FBA Shipment ID</th>
                    <th class="sorting" tabindex="0" aria-controls="example" rowspan="1" colspan="1">Units Shipped</th>
                    <th class="sorting" tabindex="0" aria-controls="example" rowspan="1" colspan="1" >Outbound Date</th>

                  </tr>
                </thead>

                <tbody>
    <?php
    $sqlQuery = "SELECT fba_ship_id, fba_ship_date, fnsku, COUNT(*) AS total_count
                 FROM process
                 WHERE fba_shipped = 'yes'
                 GROUP BY fba_ship_id, fba_ship_date, fnsku;";
    
    $stmt = $conn->prepare($sqlQuery);
    $stmt->execute();

    $data = [];

    // Group data by fba_ship_id and calculate total counts
    foreach ($stmt->fetchAll() as $row) {
        $data[$row['fba_ship_id']]['rows'][] = $row;
        if (!isset($data[$row['fba_ship_id']]['total'])) {
            $data[$row['fba_ship_id']]['total'] = 0;
        }
        $data[$row['fba_ship_id']]['total'] += $row['total_count'];
    }

    // Render Table Rows
    foreach ($data as $fba_id => $shipment) {
        $firstRow = $shipment['rows'][0]; // Get the first row for general info display
    ?>
        <tr>
            <td>
                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modal<?= $fba_id ?>">
                    View Details
                </button>
            </td>
            <td><?= $firstRow['fba_ship_id'] ?></td>
            <td><?= number_format($shipment['total']) ?></td>  <!-- Total Count in Main Table -->
            <td><?= $firstRow['fba_ship_date'] ?></td>
            
        </tr>

    <?php
    }
    ?>

    <!-- Modal for each FBA Shipment ID -->
    <?php foreach ($data as $fba_id => $shipment) { ?>
        <div class="modal fade" id="modal<?= $fba_id ?>" tabindex="-1" aria-labelledby="modalLabel<?= $fba_id ?>" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalLabel<?= $fba_id ?>">FBA Shipment Details</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p><strong>FBA ID:</strong> <?= $shipment['rows'][0]['fba_ship_id'] ?></p>
                        <p><strong>Ship Date:</strong> <?= $shipment['rows'][0]['fba_ship_date'] ?></p>

                        <!-- List for FNSKU Details -->
                        <h6>FNSKU Breakdown:</h6>
                        <ul class="list-group">
                            <?php foreach ($shipment['rows'] as $row) { ?>
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    <?= $row['fnsku'] ?>
                                    <span class="badge bg-primary rounded-pill"><?= number_format($row['total_count']) ?></span>
                                </li>
                            <?php } ?>
                        </ul>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>
</tbody>





              </table>
            </div>

          </div>

        </div>
        <!-- content-wrapper ends -->

      </div>
      <!-- main-panel ends -->
    </div>
    <!-- page-body-wrapper ends -->
  </div>
  <!-- container-scroller -->

  <?php require("../imports/importjs.php") ?>
    <!-- Bootstrap CSS -->


<!-- Bootstrap JS Bundle (Popper.js included) -->
<script src="https://stackpath.bootstrapcdn.com/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>

  <script src="https://cdn.datatables.net/1.13.2/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.1/js/dataTables.bootstrap5.min.js"></script>

  <script>
    $(document).ready(function() {



      $("#st-table").dataTable({
        "processing": true,

        "scrollY": "400px",
        "scrollCollapse": true,
        scrollX: true,
        dom: 'lBfrtip',
        // buttons: [{
        //         extend: 'pdf',
        //         exportOptions: {
        //             columns: '.maincol'
        //         }
        //     },
        //     {
        //         extend: 'excel',
        //         exportOptions: {
        //             columns: '.maincol'
        //         }
        //     }
        // ],
        //   
        //                                            "responsive": true,
        //                                            "ordering": false,

        "lengthMenu": [
          [300, 500, 1000, 5000],
          [300, 500, 1000, 5000]
        ],
        "language": {
          "processing": "<i class='fa fa-refresh fa-spin'></i>"
        },

      });
    });
  </script>

</body>

</html>