<?php
require_once '../resource/sessions.php';
require_once '../master_functions.php';
require_once '../db/Config.php';

$db = new Config();
$conn = $db->getConnection();

/**
 * Month is set by the HEADER month picker (POST date=YYYY-MM).
 * Keep it consistent here too.
 */
$currentmonth = date('Y-m');
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['date'])) {
  $currentmonth = date('Y-m', strtotime($_POST['date']));
}

$sub_menu = 'dash';

/* -------------------------
   Dashboard count functions
   ------------------------- */
function StockAtHand() {
  global $conn;
  $count = 0;
  try {
    $stmt = $conn->prepare("SELECT COUNT(*) total FROM process WHERE fba_shipped='no' AND is_disposed='no';");
    $stmt->execute();
    if ($row = $stmt->fetch()) $count = $row['total'];
  } catch (Exception $exc) { echo "Unexpected Error Occured"; }
  return $count;
}
function FBAStockAtHand() {
  global $conn;
  $count = 0;
  try {
    $stmt = $conn->prepare("SELECT COUNT(*) total FROM process WHERE fba_shipped='no' AND is_disposed='no' AND sellable=1;");
    $stmt->execute();
    if ($row = $stmt->fetch()) $count = $row['total'];
  } catch (Exception $exc) { echo "Unexpected Error Occured"; }
  return $count;
}
function DisposalStockAtHand() {
  global $conn;
  $count = 0;
  try {
    $stmt = $conn->prepare("SELECT COUNT(*) total FROM process WHERE fba_shipped='no' AND is_disposed='no' AND sellable=3;");
    $stmt->execute();
    if ($row = $stmt->fetch()) $count = $row['total'];
  } catch (Exception $exc) { echo "Unexpected Error Occured"; }
  return $count;
}
function ReworkStockAtHand() {
  global $conn;
  $count = 0;
  try {
    $stmt = $conn->prepare("SELECT COUNT(*) total FROM process WHERE fba_shipped='no' AND is_disposed='no' AND sellable=2;");
    $stmt->execute();
    if ($row = $stmt->fetch()) $count = $row['total'];
  } catch (Exception $exc) { echo "Unexpected Error Occured"; }
  return $count;
}
function PendingFBA() {
  global $conn, $currentmonth;
  $count = 0;
  try {
    $stmt = $conn->prepare("SELECT COUNT(*) total FROM process WHERE sellable=1 AND date_received LIKE :m;");
    $stmt->execute([':m' => "%$currentmonth%"]);
    if ($row = $stmt->fetch()) $count = $row['total'];
  } catch (Exception $exc) { echo "Unexpected Error Occured"; }
  return $count;
}
function UnsellableReturned() {
  global $conn, $currentmonth;
  $count = 0;
  try {
    $stmt = $conn->prepare("SELECT COUNT(*) total FROM process WHERE sellable=3 AND date_received LIKE :m;");
    $stmt->execute([':m' => "%$currentmonth%"]);
    if ($row = $stmt->fetch()) $count = $row['total'];
  } catch (Exception $exc) { echo "Unexpected Error Occured"; }
  return $count;
}
function QtyReturned() {
  global $conn, $currentmonth;
  $count = 0;
  try {
    $stmt = $conn->prepare("SELECT COUNT(*) total FROM process WHERE date_received LIKE :m;");
    $stmt->execute([':m' => "%$currentmonth%"]);
    if ($row = $stmt->fetch()) $count = $row['total'];
  } catch (Exception $exc) { echo "Unexpected Error Occured"; }
  return $count;
}
function SellableReturned() {
  global $conn, $currentmonth;
  $count = 0;
  try {
    $stmt = $conn->prepare("SELECT COUNT(*) total FROM process WHERE date_received LIKE :m AND sellable=1;");
    $stmt->execute([':m' => "%$currentmonth%"]);
    if ($row = $stmt->fetch()) $count = $row['total'];
  } catch (Exception $exc) { echo "Unexpected Error Occured"; }
  return $count;
}
function ReworkReturned() {
  global $conn, $currentmonth;
  $count = 0;
  try {
    $stmt = $conn->prepare("SELECT COUNT(*) total FROM process WHERE date_received LIKE :m AND sellable=2;");
    $stmt->execute([':m' => "%$currentmonth%"]);
    if ($row = $stmt->fetch()) $count = $row['total'];
  } catch (Exception $exc) { echo "Unexpected Error Occured"; }
  return $count;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Admin Dashboard</title>

  <?php require('../imports/importcss.php'); ?>
  <link rel="stylesheet" href="../assets/css/style.css">
  <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css">

  <style>
    /* ---- Cards polish ---- */
    .dashboard-card { border-radius: 14px; overflow: hidden; }
    .dashboard-card-header { font-weight: 800; letter-spacing: .02em; }

    /* ============================================================
       MONTHLY ACTIVITY: 1 ROW (3 CARDS) + KEEP YOUR COLOR CODING
       - uses your existing classes: ccolr1/ccolr2/ccolr4 and
         text-open/text-red/text-parshipped etc.
       ============================================================ */
    .sales-activity .card-body{
      padding: 18px;
    }
  .sales-activity .activity-row{
  display: grid;
  grid-template-columns: repeat(2, minmax(0, 1fr)); /* 2 across = 2x2 */
  gap: 16px;
  align-items: stretch;
}

/* Responsive: 2 across on tablets, 1 across on phones */
@media (max-width: 991.98px){
  .sales-activity .activity-row{ grid-template-columns: repeat(2, minmax(0, 1fr)); }
  .sales-activity .so-inner-widget{ padding: 18px 16px; }
}
@media (max-width: 575.98px){
  .sales-activity .activity-row{ grid-template-columns: 1fr; }
}
    .sales-activity .so-inner-widget{
      width: 100%;
      height: 100%;
      border: 1px solid rgba(0,0,0,.08);
      border-radius: 16px;
      padding: 20px 18px;
      background: #fff;
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      text-align: center;
    }
    .sales-activity .mobileicons{ margin-bottom: 10px !important; }
    .sales-activity .mobileicons i{ font-size: 38px; line-height: 1; display: inline-block; }
    .sales-activity .legend{
      line-height: 1.05;
      font-weight: 900;
      font-size: 2.2rem;
      margin-bottom: 6px;
    }
    .sales-activity .sales-qty{
      font-size: 0.8rem;
      letter-spacing: 0.08em;
      margin-bottom: 14px;
      opacity: 0.75;
      text-transform: uppercase;
    }
    .sales-activity .qty-label label{
      font-size: 0.78rem;
      letter-spacing: 0.06em;
      opacity: 0.9;
      margin: 0;
      line-height: 1.25;
      max-width: 280px;
    }
    .sales-activity .so-inner-widget-separator{ display:none !important; }

    

    /* ---- Inventory Summary: clean flex rows ---- */
    .inventory-summary .inv-summary{
      display:flex; align-items:center; justify-content:space-between; gap:12px;
      padding: 10px 0; border-bottom: 1px solid rgba(0,0,0,.06);
    }
    .inventory-summary .inv-summary:last-child{ border-bottom:0; }
    .inventory-summary .inv-summary label{ margin:0; flex:1 1 auto; max-width:70%; line-height:1.2; }
    .inventory-summary .inv-summary .qty{ flex:0 0 auto; font-weight:900; font-size:1.45rem; line-height:1; }

    /* ---- Top Returned Items ---- */
    .top-items-grid{
      display:grid;
      grid-template-columns: repeat(6, minmax(0,1fr));
      gap: 14px;
    }
    @media (max-width: 1199.98px){ .top-items-grid{ grid-template-columns: repeat(3, minmax(0,1fr)); } }
    @media (max-width: 575.98px){ .top-items-grid{ grid-template-columns: repeat(2, minmax(0,1fr)); } }

    .top-item{
      border: 1px solid rgba(0,0,0,.06);
      border-radius: 14px;
      padding: 14px;
      background: #fff;
      transition: transform .12s ease, box-shadow .12s ease;
      cursor: pointer;
    }
    .top-item:hover{
      transform: translateY(-2px);
      box-shadow: 0 10px 22px rgba(0,0,0,.08);
    }
    .top-item .item-image{
      width: 100%;
      height: 120px;
      display:flex;
      align-items:center;
      justify-content:center;
      overflow:hidden;
      background: transparent;
      border-radius: 0;
      padding: 0;
      margin-bottom: 4px;
    }
    .top-item .item-image img{
      max-width: 100%;
      max-height: 100%;
      object-fit: contain;
      display:block;
      pointer-events: none;
    }
    .top-item .name{ margin-top: 10px; font-weight: 500; }
    .top-item .top-quantity{ margin: 6px 0 0; font-weight: 900; }

    /* ---- Sexy modal tiles ---- */
    .stat-tile{
      background: #f9fafb;
      border: 1px solid rgba(0,0,0,.06);
      border-radius: 14px;
      padding: 14px 16px;
      text-align: center;
    }
    .stat-tile label{
      display:block;
      font-size: .7rem;
      letter-spacing: .08em;
      text-transform: uppercase;
      opacity: .65;
      margin-bottom: 6px;
    }
    .stat-tile span{
      font-size: 1.65rem;
      font-weight: 900;
      line-height: 1.1;
      display:block;
    }
    .stat-muted{ background: rgba(0,0,0,.035); }
    #modalItemImage{ max-height: 240px; object-fit: contain; }
    
    
    
  </style>
</head>

<body class="with-welcome-text">
<div class="container-scroller">
  <?php require("../sections/header.php") ?>

  <div class="container-fluid page-body-wrapper">
    <?php require("../sections/navbar.php") ?>

    <div class="main-panel">
      <div class="content-wrapper">
        <div class="row">
          <div class="col-sm-12">
            <div class="home-tab">

              <div class="d-sm-flex align-items-center justify-content-between border-bottom">
                <ul class="nav nav-tabs" role="tablist">
                  <li class="nav-item">
                    <a class="nav-link active ps-0" id="home-tab" data-bs-toggle="tab" href="#overview" role="tab" aria-controls="overview" aria-selected="true">Dashboard</a>
                  </li>
                </ul>
              </div>

              <div class="tab-content tab-content-basic">
                <div class="tab-pane fade show active" id="overview" role="tabpanel" aria-labelledby="overview">

                  <div class="row">
                    <div class="col-sm-12">
                      <div class="row dashboard-section">

                        <!-- Monthly Activity (NOW ONE ROW) -->
                        <!-- Monthly Activity (4x4 grid) -->
<div class="col-lg-8 col-md-8 col-sm-12 sales-activity">
  <div class="card dashboard-card h-100">
    <div class="card-header dashboard-card-header">Monthly Activity</div>
    <div class="card-body">
      <div class="activity-row">

        <!-- Total Units Received -->
        <div class="so-inner-widget">
          <div class="mobileicons"><i class="mdi mdi-gift ccolr1"></i></div>
          <div class="legend over-flow fw-light text-open" id="ab74264b2"><?= number_format(QtyReturned()) ?></div>
          <div class="sales-qty"><span class="font-xs text-muted">Units</span></div>
          <div class="qty-label">
            <label class="fw-light text-uppercase d-flex align-items-center justify-content-center gap-2">
              <!-- svg unchanged -->
              Total Units Received
            </label>
          </div>
        </div>

        <!-- Sellable FBA Units Received -->
        <div class="so-inner-widget">
          <div class="mobileicons"><i class="mdi mdi-truck-delivery ccolr2"></i></div>
          <div class="legend over-flow fw-light text-red" id="af5210f5f"><?= number_format(SellableReturned()) ?></div>
          <div class="sales-qty"><span class="font-xs text-muted">Units</span></div>
          <div class="qty-label">
            <label class="fw-light text-uppercase d-flex align-items-center justify-content-center gap-2">
              <!-- svg unchanged -->
              Sellable FBA Units Received
            </label>
          </div>
        </div>

        <!-- Rework Units Received -->
        <div class="so-inner-widget">
          <div class="mobileicons"><i class="mdi mdi-truck-delivery ccolr2"></i></div>
          <div class="legend over-flow fw-light text-red" id="reworkUnits"><?= number_format(ReworkReturned()) ?></div>
          <div class="sales-qty"><span class="font-xs text-muted">Units</span></div>
          <div class="qty-label">
            <label class="fw-light text-uppercase d-flex align-items-center justify-content-center gap-2">
              <!-- svg unchanged -->
              Rework Units Received
            </label>
          </div>
        </div>

        <!-- Unsellable Units Received -->
        <div class="so-inner-widget">
          <div class="mobileicons"><i class="mdi mdi-invoice ccolr4"></i></div>
          <div class="legend over-flow fw-light text-parshipped" id="a6f9c8d99"><?= number_format(UnsellableReturned()) ?></div>
          <div class="sales-qty"><span class="font-xs text-muted">Units</span></div>
          <div class="qty-label">
            <label class="fw-light text-uppercase d-flex align-items-center justify-content-center gap-2">
              <!-- svg unchanged -->
              Unsellable Units Received
            </label>
          </div>
        </div>

      </div><!-- /activity-row -->
    </div>
  </div>
</div>

                        <!-- Inventory Summary -->
                        <div class="col-lg-4 col-md-4 col-sm-12 inventory-summary">
                          <div class="card dashboard-card">
                            <div class="card-header dashboard-card-header">Inventory Summary</div>
                            <div class="card-body">
                              <div class="inv-summary">
                                <label class="text-uppercase fw-light font-small text-void">Quantity In Warehouse</label>
                                <div class="qty text-plain"><?= number_format(StockAtHand()) ?></div>
                              </div>
                              <div class="inv-summary">
                                <label class="text-uppercase fw-light font-small text-void">Quantity Pending FBA</label>
                                <div class="qty text-plain"><?= number_format(FBAStockAtHand()) ?></div>
                              </div>
                              <div class="inv-summary">
                                <label class="text-uppercase fw-light font-small text-void">Quantity Pending Rework</label>
                                <div class="qty text-plain"><?= number_format(ReworkStockAtHand()) ?></div>
                              </div>
                              <div class="inv-summary">
                                <label class="text-uppercase fw-light font-small text-void">Quantity Pending Disposal</label>
                                <div class="qty text-plain"><?= number_format(DisposalStockAtHand()) ?></div>
                              </div>
                            </div>
                          </div>
                        </div>

                      </div><!-- /dashboard-section -->
                    </div>
                  </div>

                  <!-- Top Returned Items -->
                  <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                      <div class="card dashboard-card placeholder-container">
                        <div class="card-header dashboard-card-header d-flex align-items-center justify-content-between">
                          Top Returned Items
                          <div class="small text-muted">Month: <strong><?= htmlspecialchars($currentmonth) ?></strong></div>
                        </div>

                        <div class="card-body">
                          <div class="top-items-grid">
                            <?php
                            $query = "SELECT 
                                COUNT(*) AS totalreturn,
                                process.fnsku,
                                MIN(catalog.`product-name`) AS `product-name`,
                                MIN(catalog.Image) AS Image
                              FROM `process`
                              LEFT JOIN catalog ON catalog.fnsku = process.fnsku
                              WHERE process.date_received LIKE :m
                              GROUP BY process.fnsku
                              ORDER BY totalreturn DESC 
                              LIMIT 6;";
                            $stmt = $conn->prepare($query);
                            $stmt->execute([':m' => "%$currentmonth%"]);

                            while ($row = $stmt->fetch()) {
                              $img = !empty($row['Image']) ? $row['Image'] : 'https://axiominventorymanagement.com/brands/walkee/assets/images/noimage.jpg';
                              $productName = $row['product-name'] ?: 'No Catalog Data';
                              $fnsku = trim($row['fnsku'] ?? '');
                              $totalreturn = (int)($row['totalreturn'] ?? 0);
                            ?>
                              <div class="top-item text-center open-item-modal-card"
                                   role="button"
                                   tabindex="0"
                                   data-fnsku="<?= htmlspecialchars($fnsku) ?>"
                                   data-product="<?= htmlspecialchars($productName) ?>"
                                   data-image="<?= htmlspecialchars($img) ?>"
                                   data-month="<?= htmlspecialchars($currentmonth) ?>">
                                <div class="item-image">
                                  <img src="<?= htmlspecialchars($img) ?>" alt="Item">
                                </div>

                                <div class="pt-2 over-flow fw-light text-void text-truncate name">
                                  <?= htmlspecialchars($productName) ?>
                                </div>

                                <h4 class="top-quantity text-plain">
                                  <?= number_format($totalreturn) ?><span class="fw-light"> Units</span>
                                </h4>
                              </div>
                            <?php } ?>
                          </div>
                        </div>

                      </div>
                    </div>
                  </div>

                  <br>

                  <!-- Reasons For Return -->
                  <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                      <div class="card dashboard-card">
                        <div class="card-header dashboard-card-header">Reasons For Return (RFR)</div>

                        <div class="row product-details card-body align-items-center">
                          <div class="col-lg-7 col-md-7 col-sm-12 total-summary">
                            <table class="table table-striped table-bordered">
                              <thead>
                                <tr>
                                  <th>Reason</th>
                                  <th class="text-end">Total Returns</th>
                                </tr>
                              </thead>
                              <tbody>
                              <?php
                                $query = "SELECT COUNT(*) totalreturn, reason
                                          FROM `process`
                                          WHERE date_received LIKE :m AND reason != 'No Data'
                                          GROUP BY reason
                                          ORDER BY totalreturn DESC;";
                                $stmt = $conn->prepare($query);
                                $stmt->execute([':m' => "%$currentmonth%"]);
                                while ($row = $stmt->fetch()) {
                                  echo "<tr>";
                                  echo "<td>" . htmlspecialchars(str_replace('_', ' ', $row['reason'])) . "</td>";
                                  echo "<td class='text-end'>" . number_format($row['totalreturn']) . "</td>";
                                  echo "</tr>";
                                }
                              ?>
                              </tbody>
                            </table>
                          </div>

                          <div class="col-lg-5 col-md-5 col-sm-12 text-center">
                            <label class="fw-light font-large text-void mb-0 w-75 text-truncate">
                              <span id="affbf1335">RFR</span>
                            </label>

                            <div class="pt-3">
                              <?php
                              $query = "SELECT COUNT(*) as totalreturn, reason
                                        FROM `process`
                                        WHERE date_received LIKE :m AND reason != 'No Data'
                                        GROUP BY reason
                                        ORDER BY totalreturn DESC;";
                              $stmt = $conn->prepare($query);
                              $stmt->execute([':m' => "%$currentmonth%"]);

                              $reasons = [];
                              $total_returns = [];
                              while ($row = $stmt->fetch()) {
                                $reasons[] = str_replace('_', ' ', $row['reason']);
                                $total_returns[] = (int)$row['totalreturn'];
                              }
                              ?>
                              <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
                              <canvas id="returnChart" width="400" height="400"></canvas>
                              <script>
                                var ctx = document.getElementById('returnChart').getContext('2d');
                                new Chart(ctx, {
                                  type: 'pie',
                                  data: {
                                    labels: <?php echo json_encode($reasons); ?>,
                                    datasets: [{
                                      data: <?php echo json_encode($total_returns); ?>,
                                      borderWidth: 1
                                    }]
                                  },
                                  options: {
                                    responsive: true,
                                    plugins: { legend: { position: 'top' } }
                                  }
                                });
                              </script>
                            </div>
                          </div>

                        </div>
                      </div>
                    </div>
                  </div>

                </div><!-- /overview -->

              </div><!-- /tab-content -->
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- ITEM MODAL -->
  <div class="modal fade" id="itemDetailModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
      <div class="modal-content rounded-4 shadow-lg">

        <div class="modal-header border-0 pb-0">
          <div class="w-100">
            <div class="d-flex align-items-start justify-content-between gap-3">
              <div>
                <h5 class="modal-title fw-bold mb-1" id="itemModalTitle">Item Summary</h5>
                <div class="small text-muted" id="modalSubtitle">Month summary</div>
              </div>
              <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
          </div>
        </div>

        <div class="modal-body pt-3">
          <div class="row g-4 align-items-start">
            <div class="col-md-4 text-center">
              <img id="modalItemImage" src="" class="img-fluid rounded-3 mb-3" alt="Item">
              <div class="small text-muted text-truncate" id="modalFnsku"></div>
            </div>

            <div class="col-md-8">
              <div class="row g-3">
                <div class="col-12">
                  <div class="stat-tile">
                    <label>Total Returned</label>
                    <span id="statTotalReturned">—</span>
                  </div>
                </div>

                <div class="col-6">
                  <div class="stat-tile">
                    <label>Sellable Units</label>
                    <span id="statSellable">—</span>
                  </div>
                </div>
                <div class="col-6">
                  <div class="stat-tile">
                    <label>Rework Units</label>
                    <span id="statRework">—</span>
                  </div>
                </div>

                <div class="col-12">
                  <div class="stat-tile stat-muted">
                    <label>Unsellable / Disposal</label>
                    <span id="statDisposed">—</span>
                  </div>
                </div>

              </div>
            </div>

          </div>
        </div>

      </div>
    </div>
  </div>

  <?php require("../imports/importjs.php") ?>

  <script>
    document.addEventListener('DOMContentLoaded', function () {
      const modalEl = document.getElementById('itemDetailModal');
      if (!modalEl || typeof bootstrap === 'undefined') return;

      const modal = new bootstrap.Modal(modalEl, { backdrop: true, keyboard: true });

      function setText(id, val) {
        const el = document.getElementById(id);
        if (el) el.innerText = String(val);
      }

      function setLoadingState() {
        setText('statTotalReturned', '…');
        setText('statSellable', '…');
        setText('statRework', '…');
        setText('statDisposed', '…');
      }

      function buildAjaxUrl(params) {
        const base = new URL(window.location.href);
        const ajaxUrl = new URL('ajax/get_item_monthly_summary.php', base);
        Object.keys(params).forEach(k => ajaxUrl.searchParams.set(k, params[k]));
        ajaxUrl.searchParams.set('_ts', Date.now());
        return ajaxUrl.toString();
      }

      async function loadSummary(fnsku, month) {
        const url = buildAjaxUrl({ fnsku, month });
        const res = await fetch(url, { cache: 'no-store' });
        if (!res.ok) throw new Error('Failed to load summary');
        return await res.json();
      }

      function openModalFromCard(cardEl) {
        const fnsku = (cardEl.dataset.fnsku || '').trim();
        const product = cardEl.dataset.product || 'Item Summary';
        const image = cardEl.dataset.image || 'https://axiominventorymanagement.com/brands/walkee/assets/images/noimage.jpg';
        const month = (cardEl.dataset.month || '').trim();

        document.getElementById('modalItemImage').src = image;
        document.getElementById('itemModalTitle').innerText = product;
        document.getElementById('modalFnsku').innerText = fnsku ? `FNSKU: ${fnsku}` : '';

        setLoadingState();
        modal.show();

        if (!fnsku) {
          setText('statTotalReturned', 0);
          setText('statSellable', 0);
          setText('statRework', 0);
          setText('statDisposed', 0);
          setText('modalSubtitle', 'No FNSKU on card');
          return;
        }

        loadSummary(fnsku, month)
          .then(data => {
            
            setText('statTotalReturned', data.total ?? 0);
            setText('statSellable', data.sellable ?? 0);
            setText('statRework', data.rework ?? 0);
            setText('statDisposed', data.disposed ?? 0);
          })
          .catch(e => {
            console.error(e);
            setText('modalSubtitle', 'Error loading summary (see console)');
            setText('statTotalReturned', '—');
            setText('statSellable', '—');
            setText('statRework', '—');
            setText('statDisposed', '—');
          });
      }

      document.querySelectorAll('.open-item-modal-card').forEach(card => {
        card.addEventListener('click', function () {
          openModalFromCard(this);
        });

        card.addEventListener('keydown', function (e) {
          if (e.key === 'Enter' || e.key === ' ') {
            e.preventDefault();
            openModalFromCard(this);
          }
        });
      });
    });
  </script>
<style>nav.navbar.fixed-top,
nav.navbar.fixed-top .navbar-brand-wrapper,
nav.navbar.fixed-top .navbar-menu-wrapper{
  min-height: 97px !important;
  height: 97px !important;
  background: #F4F5F7 !important;
}

nav.navbar.fixed-top .navbar-brand-wrapper{
  padding-top: 20px !important;
  padding-bottom: 20px !important;
}

nav.navbar.fixed-top .navbar-menu-wrapper{
  padding-top: 30px !important;
  padding-bottom: 25px !important;
}</style>
</body>
</html>