<?php
require_once '../resource/sessions.php';
require_once '../master_functions.php';
require_once '../db/Config.php';

$db = new Config();
$conn = $db->getConnection();

$currentmonth = date('Y-m');

$menu = '';
$sub_menu = 'rework-pending';


?>
<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Pending Rework</title>
  <!-- plugins:css -->

  <?php require('../imports/importcss.php'); ?>
  <!-- End plugin css for this page -->
  <!-- inject:css -->
  <link rel="stylesheet" href="../assets/css/style.css">
  <!-- endinject -->

  <!--google chart-->
  <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>

  <link rel="stylesheet" href="../assets/css/datatable/dataTables.bootstrap5.min.css">
  <link href="https://cdn.datatables.net/1.13.2/css/jquery.dataTables.min.css" rel="stylesheet" type="text/css" />
  <link href="https://cdn.datatables.net/responsive/2.4.0/css/responsive.dataTables.min.css" rel="stylesheet" type="text/css" />
  <link href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css" rel="stylesheet" type="text/css" />

  <style>
    select.form-select {
      color: #252020 !important;
    }
  </style>
</head>

<body class="with-welcome-text">

  <div class="container-scroller">
    <!-- partial:partials/_navbar.html -->
    <?php require("../sections/header.php") ?>
    <!-- partial -->
    <div class="container-fluid page-body-wrapper">
      <!-- partial:partials/_sidebar.html -->
      <?php require("../sections/navbar.php") ?>

      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div class="card">
            <div class="card-header">
              <h5 class="fw-bold fs-4"><i class="mdi mdi-cube"></i>Pending Rework</h5>
            </div>
            <div class="card-body shadow">
              <table class=" table table-striped" id="st-table" style="width: 100%;">
                <thead>
                  <tr>
                    <th class="sorting sorting_asc" tabindex="0" aria-controls="example" rowspan="1" colspan="1" aria-sort="ascending" aria-label="ID: activate to sort column descending" style="width: 0px;">ID</th>
                    
                    <th class="sorting" tabindex="0" aria-controls="example" rowspan="1" colspan="1" style="width: 0px;">Sku</th>
                    
                    <th class="sorting" tabindex="0" aria-controls="example" rowspan="1" colspan="1" style="width: 0px;">Tracking #</th>
                    <th class="sorting" tabindex="0" aria-controls="example" rowspan="1" colspan="1" style="width: 0px;">LPN</th>
                    <th class="sorting" tabindex="0" aria-controls="example" rowspan="1" colspan="1" style="width: 0px;">FNSKU</th>
                    
                    <th class="sorting" tabindex="0" aria-controls="example" rowspan="1" colspan="1" style="width: 0px;">Disposition</th>
                    <th class="sorting" tabindex="0" aria-controls="example" rowspan="1" colspan="1" style="width: 0px;">Process Date</th>
                    
                  </tr>
                </thead>

                
              </table>
            </div>

          </div>

        </div>
        <!-- content-wrapper ends -->

      </div>
      <!-- main-panel ends -->
    </div>
    <!-- page-body-wrapper ends -->
  </div>
  <!-- container-scroller -->

  <?php require("../imports/importjs.php") ?>

  <script src="https://cdn.datatables.net/1.13.2/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.1/js/dataTables.bootstrap5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>

  <script>
    $(document).ready(function() {
          $("#st-table").DataTable({
            "processing": true,
            "serverSide": true,
            "dom": 'Blfrtip',
                "buttons": [{
                        extend: 'pdf',
                        orientation: 'landscape', // Set orientation to landscape
                        pageSize: 'letter', // You can change this if needed
                        customize: function (doc) {
                    // Fit the content within the page width
                    var colCount = [];
                    $('#st-table').find('thead th').each(function () {
                        colCount.push('*');
                    });
                    doc.content[1].table.widths = colCount;
                    
                    // Ensure table content is scaled down to fit page
                    doc.styles.tableHeader.fontSize = 8; // Adjust font size
                    doc.styles.tableBodyOdd.fontSize = 6;
                    doc.styles.tableBodyEven.fontSize = 6;

                    // Add margin and content scaling if needed
                    doc.pageMargins = [10, 10, 10, 10]; // [left, top, right, bottom] margins
                    doc.defaultStyle.fontSize = 8; // Font size for the entire document
                }
                       
                    },
                    {
                        extend: 'excel',
                        
                    }
                ],// Enable server-side processing
            "scrollY": "400px",
            "scrollCollapse": true,
            "scrollX": true,
            "ajax": {
              "url": "ssp/fetch_rework_pending.php", // Link to the PHP script
              "type": "POST",
              "dataSrc": function (json) {
      console.log(json); // Debug the server response here
      return json.data;
    }
            },
            
            "lengthMenu": [
              [300, 500, 1000, 5000],
              [300, 500, 1000, 5000]
            ],
            "language": {
              "processing": "<i class='fa fa-refresh fa-spin'></i>"
            }
          });
    });

  </script>

</body>

</html>