<?php
require_once '../resource/sessions.php';
require_once '../master_functions.php';
require_once '../db/Config.php';
require_once 'model/UsersModel.php';
$UsersObj = new UsersModel();

$db = new Config();
$conn = $db->getConnection();


$sub_menu = 'users';

$userid = filter_input(INPUT_GET, 'id', FILTER_UNSAFE_RAW);
if (!empty($userid)) {
    if ($UsersObj->retrieveUsersById($userid)) {
        // echo "::" . $userid;
    } else {
        // echo $UsersObj->getResult();
    }
}

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Users</title>
    <!-- plugins:css -->

    <?php require('../imports/importcss.php'); ?>
    <!-- End plugin css for this page -->
    <!-- inject:css -->
    <link rel="stylesheet" href="../assets/css/style.css">
    <!-- endinject -->

    <!--google chart-->
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>




</head>

<body class="with-welcome-text">

    <div class="container-scroller">
        <!-- partial:partials/_navbar.html -->
        <?php require("../sections/header.php") ?>
        <!-- partial -->
        <div class="container-fluid page-body-wrapper">
            <!-- partial:partials/_sidebar.html -->
            <?php require("../sections/navbar.php") ?>

            <!-- partial -->
            <div class="main-panel">
                <div class="content-wrapper">
                   
            <div class="card">
                <div class="body">
                    <div class="container">
                        <h4 class="dashboard-title">New Users</h4>


                        <form class="form-horizontal Users_form" method="post" class="" enctype="multipart/form-data" accept-charset="utf-8">


                            <div class="row">
                                <input type="hidden" class="status" name="status" value="<?php
                                                                                            if (!empty($userid)) {
                                                                                                echo "editUsers";
                                                                                            } else {
                                                                                                echo "addUsers";
                                                                                            }
                                                                                            ?>">
                                <input type="hidden" name="id" value="<?php
                                                                        if (!empty($userid)) {
                                                                            echo $userid;
                                                                        }
                                                                        ?>">


                                <div class="col-lg-4 col-md-4 col-sm-12">
                                    <div class=" mb-3">
                                        <label for=" firstname" class=" form-label">First Name *</label>
                                        <input type="text" class=" form-control" autocomplete="off" name=" firstname" id="firstname" value="<?= $UsersObj->getFirstname() ?>" placeholder="First Name" required>

                                    </div>
                                </div>

                                <div class="col-lg-4 col-md-4 col-sm-12">
                                    <div class=" mb-3">
                                        <label for="lastname" class=" form-label">Last Name *</label>
                                        <input type="text" class=" form-control" autocomplete="off" name="lastname" id="lastname" value="<?= $UsersObj->getLastname() ?>" placeholder="Last Name" required>

                                    </div>
                                </div>

                                <div class="col-lg-4 col-md-4 col-sm-12">
                                    <div class=" mb-3">
                                        <label for="email" class=" form-label">Email *</label>
                                        <input type="email" class=" form-control" autocomplete="off" name="email" id="email" value="<?= $UsersObj->getEmail() ?>" placeholder="Email" required>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-md-3 col-sm-12">
                                    <div class=" mb-3">
                                        <label for="tel" class=" form-label">Telephone</label>
                                        <input type="tel" class=" form-control" autocomplete="off" name="tel" id="tel" value="<?= $UsersObj->getTel() ?>" placeholder="Telephone">
                                    </div>
                                </div>


                                <div class="col-lg-3 col-md-3 col-sm-12">
                                    <div class=" mb-3">
                                        <label for="usergroup" class=" form-label">User Type *</label>
                                        <select name="usertype" id="user_role" class=" form-select" required>
                                            <option value="">Select</option>
                                            <option value="2" <?php if ($UsersObj->getusertype() == "2") {
                                                                    echo "selected";
                                                                } ?>>Employee</option>
                                            <option value="1" <?php if ($UsersObj->getusertype() == "1") {
                                                                    echo "selected";
                                                                } ?>>Admin</option>
                                            

                                        </select>


                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-sm-12">
                                    <div class="mb-3">
                                        <label for="username" class=" form-label">Log on Credentials/Username *</label>
                                        <input type="text" class=" form-control" name="username" id="username" value="<?= $UsersObj->getUsername() ?>" placeholder="Log on Credentials" required>

                                    </div>
                                </div>
                               

                                <?php
                                if (empty($userid)) {
                                ?>

                                    <div class="col-lg-3 col-md-3 col-sm-12">
                                        <div class="mb-3">

                                            <label for="password" class=" form-label">Password *</label>
                                            <input type="text" class=" form-control" name="password" id="password" placeholder="Password" value="" required>

                                        </div>
                                    </div>
                                    
                                <?php
                                }
                                ?>
                            </div>

                            <div class=" d-flex justify-content-center mt-3 mb-3">
                                <button type="submit" class="btn  btn-primary btn_submit_Users" value="true">
                                    <i class="fa fa-floppy-o" aria-hidden="true"></i>
                                    <?php
                                    if (!empty($userid)) {
                                        echo "Update Records";
                                    } else {
                                        echo "Save Details";
                                    }
                                    ?>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
                </div>
                <!-- page-body-wrapper ends -->
            </div>
            <!-- container-scroller -->

            <?php require("../imports/importjs.php") ?>
            <script>
                 $(document).ready(function() {

$('.Users_form').submit(function(event) {
    event.preventDefault();

    var status = $(".status").val();

    $.ajax({
        url: 'model/UsersController.php',
        type: 'POST',
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            $('.btn_submit_Users').attr("disabled", "disabled");
            $('.Users_form').css("opacity", ".5");
        },
        success: function(result) {
            $('.Users_form').css("opacity", "");
            $(".btn_submit_Users").removeAttr("disabled");

            var fields = result.split('|');
            var id = fields[0];
            var msg = fields[1];

            if (id == 1) {


                if (status == "addUsers") {
                    alert("User Added");
                    $('.select').val(null).trigger('change');
                    $('.Users_form')[0].reset();

                } else if (status == "editUsers") {
                    alert(msg);
                }
            } else if (id == 2) {
                alert(msg);
            }
        },
        error: function(err) {
            alert(err);
            $('.Users_form').css("opacity", "");
            $(".btn_submit_Users").removeAttr("disabled");
        }
    });
});
//ENd of form
});
            </script>
</body>

</html>