<?php
require_once '../resource/sessions.php';
require_once '../master_functions.php';
require_once '../db/Config.php';

$db = new Config();
$conn = $db->getConnection();

if (empty($currentmonth)) {
    $currentmonth = date('Y-m');
}


$menu = '';
$sub_menu = 'bynick';


?>
<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>By Nickname</title>
  <!-- plugins:css -->

  <?php require('../imports/importcss.php'); ?>
  <!-- End plugin css for this page -->
  <!-- inject:css -->
  <link rel="stylesheet" href="../assets/css/style.css">
  <!-- endinject -->

  <!--google chart-->
  <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>

  <link rel="stylesheet" href="../assets/css/datatable/dataTables.bootstrap5.min.css">
  <link href="https://cdn.datatables.net/1.13.2/css/jquery.dataTables.min.css" rel="stylesheet" type="text/css" />
  <link href="https://cdn.datatables.net/responsive/2.4.0/css/responsive.dataTables.min.css" rel="stylesheet" type="text/css" />
  <link href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css" rel="stylesheet" type="text/css" />

  <style>
    select.form-select {
      color: #252020 !important;
    }
  </style>
</head>

<body class="with-welcome-text">

  <div class="container-scroller">
    <!-- partial:partials/_navbar.html -->
    <?php require("../sections/header.php") ?>
    <!-- partial -->
    <div class="container-fluid page-body-wrapper">
      <!-- partial:partials/_sidebar.html -->
      <?php require("../sections/navbar.php") ?>

      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div class="card">
            <div class="card-header">
              <h5 class="fw-bold fs-4"><i class="mdi mdi-cube"></i>Nickname Report for <?= date('F Y', strtotime($currentmonth))?></h5>
              <input type="hidden" value="<?= $currentmonth ?>" id="currentmonth" />
            </div>
            <div class="card-body shadow">
              <table class=" table table-striped" id="st-table" style="width: 100%;">
                <thead>
                  <tr>
                    <th tabindex="0" aria-controls="example" rowspan="1" colspan="1" aria-sort="ascending">Nickname</th>
                    <th class="sorting" tabindex="0" aria-controls="example" rowspan="1" colspan="1">Sellable Quantity</th>
                    <th class="sorting" tabindex="0" aria-controls="example" rowspan="1" colspan="1">Total Received</th>
                    <th class="sorting" tabindex="0" aria-controls="example" rowspan="1" colspan="1">Sellable</th>


                  </tr>
                </thead>

                
              </table>
            </div>

          </div>

        </div>
        <!-- content-wrapper ends -->

      </div>
      <!-- main-panel ends -->
    </div>
    <!-- page-body-wrapper ends -->
  </div>
  <!-- container-scroller -->

  <?php require("../imports/importjs.php") ?>

  <script src="https://cdn.datatables.net/1.13.2/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.1/js/dataTables.bootstrap5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>

  <script>
  $(document).ready(function() {
            var currentMonth = $('#currentmonth').val();
            $('#st-table').DataTable({
                "processing": true,
                "serverSide": true,
                "dom": 'Bfrtip',
                "buttons": [{
                        extend: 'pdf',
                        orientation: 'landscape', // Set orientation to landscape
                            pageSize: 'letter', // You can change this if needed
                            customize: function (doc) {
                             doc.content[1].table.widths = '*'; // Fit table width to page
                            }
                       
                    },
                    {
                        extend: 'excel',
                        
                    }
                ],
                "ajax": {
                    "url": "ssp/fetch_nick.php",  // Make sure this URL is correct
                    "type": "POST",
                    "data": function(d) {
                            d.currentmonth = currentMonth;  // Add the current month to the request
                        }
                },
                "scrollY": "400px",
                "scrollCollapse": true,
                "scrollX": true,
                "lengthMenu": [
                    [300, 500, 1000, 5000],
                    [300, 500, 1000, 5000]
                ],
                "columns": [
                    { "data": "abv" },
                    { "data": "total" },
                    { "data": "total_received" },
                    { 
                      "data": "sellable_percent", 
                      // Optionally render the percentage value
                      "render": function(data, type, row) {
                          return data;
                      }
                    }
                ],
                "ordering": true,
                "order": [[3, "desc"]] // Set initial sort on sellable_percent (4th column, index 3)
            });
});


</script>


</body>

</html>