<?php
session_start();
include_once 'model/UsersModel.php';
include_once '../db/Config.php';

if (isset($_SESSION["userid_brand"])) {
    header('Location: ../brandproducts/home.php');
}

$_STATUS = 0;
$message = "";


if ((isset($_POST["userid"])) && (isset($_POST["securecode"]))) {
    $UsersObj = new UsersModel();

    $username = filter_input(INPUT_POST, 'userid', FILTER_UNSAFE_RAW);
    $password = filter_input(INPUT_POST, 'securecode', FILTER_UNSAFE_RAW);
    


    if ($UsersObj->loginUser($username, $password)) {
        header("Location: ../brandproducts/home.php");
    } else {
        $_STATUS = 1;

        $message = $UsersObj->getResult();
    }
}
?>
<!DOCTYPE html>
<html class="no-js" lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>AXIOM PREP LOGIN</title>
    <!-- plugins:css -->

    <?php require('../imports/importcss.php'); ?>
    <!-- End plugin css for this page -->
    <!-- inject:css -->
    <link rel="stylesheet" href="../assets/css/style.css">


</head>

<body>
    <div class="container-scroller">
        <div class="container-fluid page-body-wrapper full-page-wrapper ">
            <div class="content-wrapper d-flex align-items-center auth px-0">
                <div class="row w-100 mx-0">
                    <div class="col-lg-4 mx-auto shadow">
                        <div class="auth-form-light text-left py-5 px-4 px-sm-5">
                            <!-- <div class="brand-logo">
                                <img src="../assets/images/logo.svg" alt="logo">
                            </div> -->
                            <h4>AXIOM BRAND MANAGEMENT</h4>
                            <h6 class="fw-light">Sign in to continue.</h6>
                            <?php if ((isset($_STATUS)) && ($_STATUS == 1)) { ?>
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                    <?= $message ?>
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            <?php } ?>
                            <form class="pt-3" method="POST">
                                <div class="form-group">
                                    <input type="text" class="form-control form-control-lg" autocomplete="off" name="userid" placeholder="Username">
                                </div>
                                <div class="form-group">
                                    <input type="password" class="form-control form-control-lg" name="securecode" autocomplete="off" placeholder="Password">
                                </div>
                                <div class="mt-3">
                                    <button type="submit" class="btn btn-block btn-primary btn-lg font-weight-medium auth-form-btn">SIGN IN</button>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!-- content-wrapper ends -->
        </div>
        <!-- page-body-wrapper ends -->
    </div>
    <!-- container-scroller -->

    <?php require("../imports/importjs.php") ?>



</body>

</html>