<?php
require_once '../resource/sessions.php';
require_once '../master_functions.php';
require_once '../db/Config.php';
require_once 'model/UsersModel.php';
$UsersObj = new UsersModel();

$db = new Config();
$conn = $db->getConnection();

$currentmonth = date('Y-m');
$sub_menu = 'users';

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Users</title>
    <!-- plugins:css -->

    <?php require('../imports/importcss.php'); ?>
    <!-- End plugin css for this page -->
    <!-- inject:css -->
    <link rel="stylesheet" href="../assets/css/style.css">
    <!-- endinject -->

    <!--google chart-->
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>




</head>

<body class="with-welcome-text">

    <div class="container-scroller">
        <!-- partial:partials/_navbar.html -->
        <?php require("../sections/header.php") ?>
        <!-- partial -->
        <div class="container-fluid page-body-wrapper">
            <!-- partial:partials/_sidebar.html -->
            <?php require("../sections/navbar.php") ?>

            <!-- partial -->
            <div class="main-panel">
                <div class="content-wrapper">
                    <div class="card">
                        <div class="body">
                            <div class="container">
                                <div class=" d-flex justify-content-between mt-3 mb-3">
                                    <h4 class="dashboard-title">Users List</h4>
                                    <a class="btn btn-outline-primary" href="newuser.php"><i class="edumi edumi-content-writing"></i> <span class="text">New User</span></a>
                                </div>
                                <div class="dashboard-table table-responsive">
                                    <table id="example" class="table table-striped" style="width:100%">
                                        <thead>
                                            <tr>

                                                <th>ID</th>
                                                <th>First Name</th>
                                                <th>Last Name</th>

                                                <th>Username</th>
                                                <th>User Type</th>


                                                <th>Tel</th>
                                                <th>Email</th>

                                                <th></th>
                                                <th></th>
                                                <th></th>


                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $jsondata3 = $UsersObj->loadUsers();
                                            $json_decoded3 = json_decode($jsondata3);

                                            foreach ($json_decoded3 as $key => $value) {
                                            ?>

                                                <tr id='<?php echo $value->id; ?>'>
                                                    <td><?= $value->id; ?></td>
                                                    <td><?= $value->firstname; ?></td>
                                                    <td><?= $value->lastname; ?></td>
                                                    <td><?= $value->username; ?></td>

                                                    <td><?= $value->usertype; ?></td>
                                                    <td><?= $value->tel; ?></td>
                                                    <td><?= $value->email; ?></td>


                                                    <td>
                                                        <a href="newuser.php?id=<?= $value->id ?>" style='color:blue;'><i class="fal fa-pencil-alt"></i> Edit</a>
                                                    </td>
                                                    <td>
                                                        <a href="reset.php?id=<?= $value->id ?>" style='color:blue;'><i class="fal fa-pencil-alt"></i> Reset Password</a>
                                                    </td>
                                                    <td>
                                                        <a onclick='deleteItem(<?= $value->id ?>)' style='color:red;'><i class="fal fa-trash-alt"></i> Delete</a>

                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- main-panel ends -->
                </div>
                <!-- page-body-wrapper ends -->
            </div>
            <!-- container-scroller -->

            <?php require("../imports/importjs.php") ?>
            <script>
                $(document).ready(function() {
                    $('#example').DataTable();
                });

                function deleteItem(id) {
                    var r = confirm("Sure!\n\n Want to Delete Record?");
                    if (r == true) {

                        $.ajax({
                            url: 'model/UsersController.php',
                            type: 'POST',
                            data: {
                                status: 'delete',
                                id: id
                            },
                            success: function(result) {

                                var fields = result.split('|');
                                var repid = fields[0];
                                var msg = fields[1];
                                if (repid == 1) {
                                    window.location.replace('users');

                                } else if (repid == 2) {
                                    alert(msg);
                                }
                            },
                            error: function(err) {
                                alert(err);
                            }
                        });
                    }
                }
            </script>
</body>

</html>