<?php
require_once '../resource/sessions.php';
require_once '../master_functions.php';
require_once '../db/Config.php';

$db = new Config();
$conn = $db->getConnection();

$currentmonth = date('Y-m');

$menu = '';
$sub_menu = 'dis-complete';


?>
<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Disposal Completed</title>
  <!-- plugins:css -->

  <?php require('../imports/importcss.php'); ?>
  <!-- End plugin css for this page -->
  <!-- inject:css -->
  <link rel="stylesheet" href="../assets/css/style.css">
  <!-- endinject -->

  <!--google chart-->
  <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>

  <link rel="stylesheet" href="../assets/css/datatable/dataTables.bootstrap5.min.css">
  <link href="https://cdn.datatables.net/1.13.2/css/jquery.dataTables.min.css" rel="stylesheet" type="text/css" />
  <link href="https://cdn.datatables.net/responsive/2.4.0/css/responsive.dataTables.min.css" rel="stylesheet" type="text/css" />

  <style>
    select.form-select {
      color: #252020 !important;
    }
  </style>
</head>

<body class="with-welcome-text">

  <div class="container-scroller">
    <!-- partial:partials/_navbar.html -->
    <?php require("../sections/header.php") ?>
    <!-- partial -->
    <div class="container-fluid page-body-wrapper">
      <!-- partial:partials/_sidebar.html -->
      <?php require("../sections/navbar.php") ?>

      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div class="card">
            <div class="card-header">
              <h5 class="fw-bold fs-4"><i class="mdi mdi-cube"></i>Completed Disposal Manifest</h5>
            </div>
            <div class="card-body shadow">
              <table class=" table table-striped" id="st-table" style="width: 100%;">
                <thead>
                  <tr>
                    <th class="sorting sorting_asc" tabindex="0" aria-controls="example" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Location: activate to sort column descending" style="width: 0px;">Location</th>
                    <th class="sorting" tabindex="0" aria-controls="example" rowspan="1" colspan="1" style="width: 0px;">Sku</th>
                    <th class="sorting" tabindex="0" aria-controls="example" rowspan="1" colspan="1" style="width: 0px;">MSKU</th>
                    <th class="sorting" tabindex="0" aria-controls="example" rowspan="1" colspan="1" style="width: 0px;">Tracking #</th>
                    <th class="sorting" tabindex="0" aria-controls="example" rowspan="1" colspan="1" style="width: 0px;">LPN</th>
                    <th class="sorting" tabindex="0" aria-controls="example" rowspan="1" colspan="1" style="width: 0px;">FNSKU</th>
                    <th class="sorting" tabindex="0" aria-controls="example" rowspan="1" colspan="1" style="width: 0px;">Nickname</th>
                    <th class="sorting" tabindex="0" aria-controls="example" rowspan="1" colspan="1" style="width: 0px;">Disposition</th>
                    <th class="sorting" tabindex="0" aria-controls="example" rowspan="1" colspan="1" style="width: 0px;">Process Date</th>
                  </tr>
                </thead>

                <tbody>
                  <?php
                  $sqlQuery = "select * from process where sellable='2' and is_disposed='yes'; ";
                  $stmt = $conn->prepare($sqlQuery);
                  $stmt->execute();

                  while ($row = $stmt->fetch()) {
                  ?>
                    <tr>
                      <td><?= $row['location'] ?></td>
                      <td><?= $row['sku'] ?></td>
                      <td><?= $row['msku'] ?></td>

                      <td><?= $row['shipping_label'] ?></td>

                      <td><?= $row['lpn'] ?></td>

                      <td><?= $row['fnsku'] ?></td>

                      <td><?= $row['abv'] ?></td>
                      <td><?= $row['sellable'] == '1' ? 'Sellable' : 'Unsellable' ?></td>
                      <td><?= $row['date_received'] ?></td>

                    </tr>
                  <?php
                  }

                  ?>
                </tbody>
              </table>
            </div>

          </div>

        </div>
        <!-- content-wrapper ends -->

      </div>
      <!-- main-panel ends -->
    </div>
    <!-- page-body-wrapper ends -->
  </div>
  <!-- container-scroller -->

  <?php require("../imports/importjs.php") ?>

  <script src="https://cdn.datatables.net/1.13.2/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.1/js/dataTables.bootstrap5.min.js"></script>

  <script>
    $(document).ready(function() {



      $("#st-table").dataTable({
        "processing": true,

        "scrollY": "400px",
        "scrollCollapse": true,
        scrollX: true,
        dom: 'lBfrtip',
        // buttons: [{
        //         extend: 'pdf',
        //         exportOptions: {
        //             columns: '.maincol'
        //         }
        //     },
        //     {
        //         extend: 'excel',
        //         exportOptions: {
        //             columns: '.maincol'
        //         }
        //     }
        // ],
        //   
        //                                            "responsive": true,
        //                                            "ordering": false,

        "lengthMenu": [
          [300, 500, 1000, 5000],
          [300, 500, 1000, 5000]
        ],
        "language": {
          "processing": "<i class='fa fa-refresh fa-spin'></i>"
        },

      });
    });
  </script>

</body>

</html>