<?php
require_once '../resource/sessions.php';
require_once '../master_functions.php';
require_once '../db/Config.php';

$db = new Config();
$conn = $db->getConnection();

$currentmonth = date('Y-m');

$sub_menu = 'dash';

function StockAtHand()
{
  global $conn;
  $count = 0;
  try {
    $sqlQuery = "select count(*) total from process where fba_shipped='no' and is_disposed='no'; ";
    $stmt = $conn->prepare($sqlQuery);
    $stmt->execute();
    $row = $stmt->fetch();
    if ($row) {
      $count = $row['total'];
    }
  } catch (Exception $exc) {
    echo  "Unexpected Error Occured";
  }
  return $count;
}
function FBAStockAtHand()
{
  global $conn;
  $count = 0;
  try {
    $sqlQuery = "select count(*) total from process where fba_shipped='no' and is_disposed='no' and sellable=1; ";
    $stmt = $conn->prepare($sqlQuery);
    $stmt->execute();
    $row = $stmt->fetch();
    if ($row) {
      $count = $row['total'];
    }
  } catch (Exception $exc) {
    echo  "Unexpected Error Occured";
  }
  return $count;
}
function DisposalStockAtHand()
{
  global $conn;
  $count = 0;
  try {
    $sqlQuery = "select count(*) total from process where fba_shipped='no' and is_disposed='no' and sellable=2; ";
    $stmt = $conn->prepare($sqlQuery);
    $stmt->execute();
    $row = $stmt->fetch();
    if ($row) {
      $count = $row['total'];
    }
  } catch (Exception $exc) {
    echo  "Unexpected Error Occured";
  }
  return $count;
}

function PendingFBA()
{
  global $conn, $currentmonth;
  $count = 0;
  try {
    $sqlQuery = "select count(*) total from process where fba_shipped='no' and item_condition !='9' and date_received like '%$currentmonth%' ; ";
    $stmt = $conn->prepare($sqlQuery);
    $stmt->execute();
    $row = $stmt->fetch();
    if ($row) {
      $count = $row['total'];
    }
  } catch (Exception $exc) {
    echo  "Unexpected Error Occured";
  }
  return $count;
}

function Disposed()
{
  global $conn, $currentmonth;
  $count = 0;
  try {
    $sqlQuery = "select count(*) total from process where is_disposed ='yes' and date_received like '%$currentmonth%'; ";
    $stmt = $conn->prepare($sqlQuery);
    $stmt->execute();
    $row = $stmt->fetch();
    if ($row) {
      $count = $row['total'];
    }
  } catch (Exception $exc) {
    echo  "Unexpected Error Occured";
  }
  return $count;
}
function ShippedFBA()
{
  global $conn, $currentmonth;
  $count = 0;
  try {
    $sqlQuery = "select count(*) total from process where fba_shipped ='yes' and date_received like '%$currentmonth%' ; ";
    $stmt = $conn->prepare($sqlQuery);
    $stmt->execute();
    $row = $stmt->fetch();
    if ($row) {
      $count = $row['total'];
    }
  } catch (Exception $exc) {
    echo  "Unexpected Error Occured";
  }
  return $count;
}

function QtyReturned()
{
  global $conn, $currentmonth;
  $count = 0;
  try {
    $sqlQuery = "select count(*) total from process where date_received like '%$currentmonth%' ; ";
    $stmt = $conn->prepare($sqlQuery);
    $stmt->execute();
    $row = $stmt->fetch();
    if ($row) {
      $count = $row['total'];
    }
  } catch (Exception $exc) {
    echo  "Unexpected Error Occured";
  }
  return $count;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Admin Dashboard</title>
  <!-- plugins:css -->

  <?php require('../imports/importcss.php'); ?>
  <!-- End plugin css for this page -->
  <!-- inject:css -->
  <link rel="stylesheet" href="../assets/css/style.css">
  <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css">
  <!-- endinject -->

  <!--google chart-->
  <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<style>
   .top-items {
  display: flex;
  justify-content: center; /* Centers items horizontally */
  align-items: center; /* Centers items vertically */
  gap: 20px; /* Optional: Add space between items */
} 
</style>



</head>

<body class="with-welcome-text">

  <div class="container-scroller">
    <!-- partial:partials/_navbar.html -->
    <?php require("../sections/header.php") ?>
    <!-- partial -->
    <div class="container-fluid page-body-wrapper">
      <!-- partial:partials/_sidebar.html -->
      <?php require("../sections/navbar.php") ?>

      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div class="row">
            <div class="col-sm-12">
              <div class="home-tab">
                <div class="d-sm-flex align-items-center justify-content-between border-bottom">
                    <ul class="nav nav-tabs" role="tablist">
                      <li class="nav-item">
                        <a class="nav-link active ps-0" id="home-tab" data-bs-toggle="tab" href="#overview" role="tab" aria-controls="overview" aria-selected="true">Dashboard</a>
                      </li>
                      <li class="nav-item">
                        <a class="nav-link" id="started-tab" data-bs-toggle="tab" href="#started" role="tab" aria-controls="started" aria-selected="false">Getting Started</a>
                      </li>
                      
                      <li class="nav-item">
                        <a class="nav-link border-0" id="more-tab" data-bs-toggle="tab" href="#more" role="tab" aria-controls="more" aria-selected="false">Updates</a>
                      </li>
                    </ul>
                    
                  </div>
                <div class="tab-content tab-content-basic">
                  <div class="tab-pane fade show active" id="overview" role="tabpanel" aria-labelledby="overview">
                    <div class="row">
                      <div class="col-sm-12">
                        <div class="row dashboard-section">
                          <div class="col-lg-8 col-md-8 col-sm-12 sales-activity">
                            <div class="card dashboard-card">
                              <div class="card-header dashboard-card-header">Monthly Activity</div>
                              <div class="card-body">
                                <div class="d-flex justify-content-between">
                                  <div class="so-inner-widget text-center">
                                    <div class="mobileicons"><i class="mdi mdi-gift ccolr1"></i></div>
                                    <p class="mb-0 cursor-pointer" data-ember-action="" data-ember-action-350="350">
                                    <div class="legend over-flow fw-light text-open" id="ab74264b2"><?= number_format(QtyReturned()) ?></div> <!---->
                                    <div class="sales-qty">
                                      <span class="font-xs">Qty</span>
                                    </div>
                                    </p>
                                    <div class="qty-label"><label class="fw-light text-uppercase">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" class="icon icon-xs align-text-top me-2">
                                          <path d="M256 32c30.3 0 59.6 5.9 87.2 17.6 26.7 11.3 50.6 27.4 71.2 48s36.7 44.5 48 71.2c11.7 27.6 17.6 56.9 17.6 87.2s-5.9 59.6-17.6 87.2c-11.3 26.7-27.4 50.6-48 71.2s-44.5 36.7-71.2 48C315.6 474.1 286.3 480 256 480s-59.6-5.9-87.2-17.6c-26.7-11.3-50.6-27.4-71.2-48s-36.7-44.5-48-71.2C37.9 315.6 32 286.3 32 256s5.9-59.6 17.6-87.2c11.3-26.7 27.4-50.6 48-71.2s44.5-36.7 71.2-48C196.4 37.9 225.7 32 256 32m0-32C114.6 0 0 114.6 0 256s114.6 256 256 256 256-114.6 256-256S397.4 0 256 0z"></path>
                                          <path d="M223 336h-.1c-4.3 0-8.3-1.8-11.3-4.8l-62.5-64c-6.2-6.3-6.1-16.4.3-22.6 6.3-6.2 16.4-6.1 22.6.3l51.2 52.4 117.6-116.6c6.3-6.2 16.4-6.2 22.6.1 6.2 6.3 6.2 16.4-.1 22.6l-129 128c-3 2.9-7.1 4.6-11.3 4.6z"></path>
                                        </svg>Units Returned</label>
                                    </div>
                                  </div>
                                  <div class="so-inner-widget-separator"></div>
                                  <div class="so-inner-widget text-center">
                                    <div class="mobileicons"><i class="mdi mdi-truck-delivery ccolr2"></i></div>
                                    <div class="legend over-flow fw-light text-red" id="af5210f5f"><?= number_format(ShippedFBA()) ?></div>
                                    <div class="sales-qty"><span class="font-xs">Units</span></div>
                                    <div class="qty-label"><label class="fw-light text-uppercase"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" class="icon icon-xs align-text-top me-2">
                                          <path d="M256 32c30.3 0 59.6 5.9 87.2 17.6 26.7 11.3 50.6 27.4 71.2 48s36.7 44.5 48 71.2c11.7 27.6 17.6 56.9 17.6 87.2s-5.9 59.6-17.6 87.2c-11.3 26.7-27.4 50.6-48 71.2s-44.5 36.7-71.2 48C315.6 474.1 286.3 480 256 480s-59.6-5.9-87.2-17.6c-26.7-11.3-50.6-27.4-71.2-48s-36.7-44.5-48-71.2C37.9 315.6 32 286.3 32 256s5.9-59.6 17.6-87.2c11.3-26.7 27.4-50.6 48-71.2s44.5-36.7 71.2-48C196.4 37.9 225.7 32 256 32m0-32C114.6 0 0 114.6 0 256s114.6 256 256 256 256-114.6 256-256S397.4 0 256 0z"></path>
                                          <path d="M369.4 204.1c0-3.7-2.2-7.1-5.6-8.8l-103.5-51.8c-2.7-1.4-6-1.4-8.7 0l-103.4 51.7c-3.5 1.7-5.7 5.3-5.7 9.2v103.3c0 3.7 2.1 7 5.4 8.7L247 366c2 2.3 5.1 3.5 8.2 3.3 1.8.1 3.5-.2 5.1-1L364 316.5c3.3-1.6 5.4-5 5.4-8.7V204.1zM256 245.2l-31-15.5 82-41 30.9 15.5-81.9 41zm0-82l29.3 14.6-82 41-29.3-14.6 82-41zm-94 56.7l31 15.4V256c0 5.3 4.2 9.7 9.5 9.7s9.5-4.4 9.5-9.7v-10.9l33 16.2v81.9l-83-41.3v-82zm102 124.9v-81.9l86-43v81.9l-86 43z"></path>
                                        </svg>Shipped FBA</label>
                                    </div>
                                  </div>
                                  <div class="so-inner-widget-separator"></div>
                                  <div class="so-inner-widget text-center">
                                    <div class="mobileicons"><i class="mdi mdi-tanker-truck ccolr3"></i></div>
                                    <div class="legend over-flow fw-light text-success" id="aa471e1b2"><?= number_format(PendingFBA()) ?></div>
                                    <div class="sales-qty"><span class="font-xs">Units</span></div>
                                    <div class="qty-label">
                                      <label class="fw-light text-uppercase">
                                        <svg id="Layer_2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" class="icon icon-xs align-text-top me-2">
                                          <g id="Layer_1-2">
                                            <path d="M437 75C388.7 26.6 324.4 0 256 0S123.3 26.6 75 75C26.6 123.3 0 187.6 0 256s26.6 132.7 75 181c48.4 48.4 112.6 75 181 75s132.7-26.6 181-75c48.4-48.4 75-112.6 75-181s-26.6-132.7-75-181zm-28.3 333.8c-40.8 40.8-95 63.3-152.7 63.3s-111.9-22.5-152.7-63.3S40 313.8 40 256.1s22.5-111.9 63.3-152.7c40.8-40.8 95-63.3 152.7-63.3s111.9 22.5 152.7 63.3c40.8 40.8 63.3 95 63.3 152.7S449.5 368 408.7 408.8z"></path>
                                            <path d="M256.1 224.9c-17.3 0-31.2 14-31.2 31.2s14 31.2 31.2 31.2 31.2-14 31.2-31.2-14-31.2-31.2-31.2zM135.7 224.9c-17.3 0-31.2 14-31.2 31.2s14 31.2 31.2 31.2 31.2-14 31.2-31.2-14-31.2-31.2-31.2zM376.5 224.9c-17.3 0-31.2 14-31.2 31.2s14 31.2 31.2 31.2 31.2-14 31.2-31.2-14-31.2-31.2-31.2z"></path>
                                          </g>
                                        </svg>Pending FBA</label>
                                    </div>
                                  </div>
                                  <div class="so-inner-widget-separator"></div>
                                  <div class="so-inner-widget text-center">
                                    <div class="mobileicons"><i class="mdi mdi-invoice ccolr4"></i></div>
                                    <p class="mb-0 cursor-pointer" data-ember-action="" data-ember-action-353="353">
                                    <div class="legend over-flow fw-light text-parshipped" id="a6f9c8d99"><?= number_format(Disposed()) ?></div>
                                    <div class="sales-qty"><span class="font-xs">Units</span></div>
                                    </p>
                                    <div class="qty-label">
                                      <label class="fw-light text-uppercase"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" class="icon icon-xs align-text-top me-2">
                                          <path d="M256 32c30.3 0 59.6 5.9 87.2 17.6 26.7 11.3 50.6 27.4 71.2 48s36.7 44.5 48 71.2c11.7 27.6 17.6 56.9 17.6 87.2s-5.9 59.6-17.6 87.2c-11.3 26.7-27.4 50.6-48 71.2s-44.5 36.7-71.2 48C315.6 474.1 286.3 480 256 480s-59.6-5.9-87.2-17.6c-26.7-11.3-50.6-27.4-71.2-48s-36.7-44.5-48-71.2C37.9 315.6 32 286.3 32 256s5.9-59.6 17.6-87.2c11.3-26.7 27.4-50.6 48-71.2s44.5-36.7 71.2-48C196.4 37.9 225.7 32 256 32m0-32C114.6 0 0 114.6 0 256s114.6 256 256 256 256-114.6 256-256S397.4 0 256 0z"></path>
                                          <path d="M255 160l65 65v119c0 4.4-3.6 8-8 8H200c-4.4 0-8-3.6-8-8V168c0-4.4 3.6-8 8-8h55m0-20h-55c-15.4 0-28 12.6-28 28v176c0 15.4 12.6 28 28 28h112c15.4 0 28-12.6 28-28V225c0-5.3-2.1-10.4-5.9-14.1l-65-65c-3.7-3.8-8.8-5.9-14.1-5.9zm33 180h-64"></path>
                                          <path d="M288 330h-64c-5.5 0-10-4.5-10-10s4.5-10 10-10h64c5.5 0 10 4.5 10 10s-4.5 10-10 10zm0-42h-64m64 10h-64c-5.5 0-10-4.5-10-10s4.5-10 10-10h64c5.5 0 10 4.5 10 10s-4.5 10-10 10zm32-63h-64c-5.5 0-10-4.5-10-10v-65c0-5.5 4.5-10 10-10s10 4.5 10 10v55h54c5.5 0 10 4.5 10 10s-4.5 10-10 10z"></path>
                                        </svg>Disposed</label>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="col-lg-4 col-md-4 col-sm-12 inventory-summary">
                            <div class="card dashboard-card">
                              <div class="card-header dashboard-card-header">Inventory Summary</div>
                              <div class="card-body">
                                <div class="inv-summary">
                                  <label class="text-uppercase fw-light font-small text-void w-65">Quantity In Warehouse</label>
                                  <div class="cursor-pointer float-end qty over-flow icon-xlarge text-plain" id="a677bd9e0"><?= number_format(StockAtHand()) ?></div>
                                </div>
                                <div class="inv-summary">
                                  <label class="text-uppercase fw-light font-small text-void w-65">Quantity Pending FBA</label>
                                  <div class="cursor-pointer float-end qty over-flow icon-xlarge text-plain" id="a677bd9e0"><?= number_format(FBAStockAtHand()) ?></div>
                                </div>
                                <div class="inv-summary">
                                  <label class="text-uppercase fw-light font-small text-void w-65">Quantity Pending Disposal</label>
                                  <div class="cursor-pointer float-end qty over-flow icon-xlarge text-plain" id="a677bd9e0"><?= number_format(DisposalStockAtHand()) ?></div>
                                </div>
                                
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    
                     <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="card dashboard-card placeholder-container">
                          <div class="card-header dashboard-card-header d-flex align-items-center justify-content-between">Top Returned Items
                            <div class="cursor-pointer dashboard-daterange-picker">
                              <div end_date="Sun Jun 30 2024 23:59:59 GMT+0530 (India Standard Time)" start_date="Sat Jun 01 2024 00:00:00 GMT+0530 (India Standard Time)" id="ember313" class="zf-daterange-picker ember-view">
                                
                                <span class="caret"></span>
                              </div>
                            </div>
                          </div>
                          <div class="placeholder-container">
                            <div class="top-selling-details">
                              <div class="top-items card-body d-flex">

                                <?php

                                $query = "SELECT 
    count(*) AS totalreturn,
    process.fnsku,
    MIN(process.lpn) AS `lpn`,
    MIN(catalog.`product-name`) AS `product-name`,  -- or MAX(), if it makes sense
    MIN(catalog.Image) AS Image  -- or MAX(), depending on your needs
FROM 
    `process` 
LEFT JOIN 
    catalog 
ON 
    catalog.fnsku = process.fnsku 
WHERE 
    process.date_received LIKE '%$currentmonth%' 
GROUP BY 
    process.fnsku
ORDER BY 
    totalreturn DESC 
LIMIT 6;
";

                                // echo $query;

                                $stmt = $conn->prepare($query);
                                $stmt->execute();

                                while ($row = $stmt->fetch()) {
                                ?>
                                  <div class="top-item text-center">
                                    <div class="item-image">
                                      <img src="<?= $row['Image'] ?>" style="width:100px;height: inherit;">
                                    </div>
                                    <div>
                                      <a id="ember342" class="ember-view " href="#">
                                        <div class="pt-3 over-flow fw-light text-void text-truncate"><?= $row['product-name'] ?></div>
                                        <h4 class="top-quantity text-plain"><?= $row['totalreturn'] ?><span class="fw-light"> Units</span></h4>
                                      </a>
                                    </div>
                                  </div>
                                <?php } ?>

                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      </div>
                    
                    
                    
                    
                    <br>
                    <div class="row">
                      <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="card dashboard-card">
                          <div class="card-header dashboard-card-header">Reasons For Return (RFR) <!----></div>
                          <div class="row product-details card-body align-items-center ">
                            <div class="col-lg-7 col-md-7 col-sm-12 total-summary">
                              <?php

                              

                              $query = "SELECT count(*) totalreturn,reason FROM `process` where process.date_received like '%$currentmonth%'   group by reason order by totalreturn desc;";

                              // echo $query;

                              $stmt = $conn->prepare($query);
                              $stmt->execute();

                              while ($row = $stmt->fetch()) {
                              ?>
                                <div class="item font-large pb-0">
                                  <label class="fw-light text-red text-plain w-75 text-truncate">
                                    <?= str_replace('_',' ',$row['reason']) ?>
                                  </label>
                                  <a id="ember347" class="ember-view" href="#">
                                    <label class="cursor-pointer float-end text-plain font-xlarge text-semibold"><?= number_format($row['totalreturn']) ?></label></a>
                                </div>
                              <?php } ?>

                            </div>
                            <div class="col-lg-5 col-md-5 col-sm-12 text-center">
                              <label class="fw-light font-large text-void mb-0 w-75 text-truncate">
                                <span id="affbf1335">RFR</span>
                              </label>
                              <div class="pt-3">
                                <div width="65" id="ember349" class="zec-container ember-view">
                                  <div>
                                    <?php
                                    $query = "SELECT count(*) as totalreturn, reason FROM `process` WHERE process.date_received LIKE '%$currentmonth%' GROUP BY reason ORDER BY totalreturn DESC;";
                                    $stmt = $conn->prepare($query);
                                    $stmt->execute();
                                    
                                    $reasons = [];
                                    $total_returns = [];
                                    
                                    while ($row = $stmt->fetch()) {
                                        $reasons[] = str_replace('_', ' ', $row['reason']);
                                        $total_returns[] = $row['totalreturn'];
                                    }
                                    ?>
                                    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
                                    <canvas id="returnChart" width="400" height="400"></canvas>
                                    <script>
    var ctx = document.getElementById('returnChart').getContext('2d');
    var returnChart = new Chart(ctx, {
        type: 'pie',
        data: {
            labels: <?php echo json_encode($reasons); ?>,
            datasets: [{
                data: <?php echo json_encode($total_returns); ?>,
                 backgroundColor: [
                    'rgba(255, 99, 132, 0.2)', 'rgba(54, 162, 235, 0.2)', 'rgba(255, 206, 86, 0.2)', 
                    'rgba(75, 192, 192, 0.2)', 'rgba(153, 102, 255, 0.2)', 'rgba(255, 159, 64, 0.2)',
                    'rgba(199, 199, 199, 0.2)', 'rgba(83, 102, 255, 0.2)', 'rgba(83, 162, 235, 0.2)',
                    'rgba(255, 206, 255, 0.2)', 'rgba(75, 192, 132, 0.2)', 'rgba(153, 102, 192, 0.2)',
                    'rgba(255, 99, 64, 0.2)', 'rgba(54, 235, 132, 0.2)', 'rgba(255, 206, 100, 0.2)',
                    'rgba(75, 102, 255, 0.2)', 'rgba(153, 192, 64, 0.2)', 'rgba(255, 206, 235, 0.2)',
                    'rgba(75, 192, 255, 0.2)', 'rgba(153, 102, 132, 0.2)'
                ],
                borderColor: [
                    'rgba(255, 99, 132, 1)', 'rgba(54, 162, 235, 1)', 'rgba(255, 206, 86, 1)',
                    'rgba(75, 192, 192, 1)', 'rgba(153, 102, 255, 1)', 'rgba(255, 159, 64, 1)',
                    'rgba(199, 199, 199, 1)', 'rgba(83, 102, 255, 1)', 'rgba(83, 162, 235, 1)',
                    'rgba(255, 206, 255, 1)', 'rgba(75, 192, 132, 1)', 'rgba(153, 102, 192, 1)',
                    'rgba(255, 99, 64, 1)', 'rgba(54, 235, 132, 1)', 'rgba(255, 206, 100, 1)',
                    'rgba(75, 102, 255, 1)', 'rgba(153, 192, 64, 1)', 'rgba(255, 206, 235, 1)',
                    'rgba(75, 192, 255, 1)', 'rgba(153, 102, 132, 1)'
                ],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                }
                
            }
        }
    });
</script>

                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      
                    </div>

                  </div>
                
                <!--end of home tab-->
                <div class="tab-pane fade" id="started" role="tabpanel" aria-labelledby="started">
                  
                      <iframe width="1000" height="563" src="https://www.loom.com/embed/1d2bf614ca4349bd9229d18a9757366c?sid=6c53cd0b-c430-4216-a5ad-7d527db88926" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>
                </div> 
                <div class="tab-pane fade" id="more" role="tabpanel" aria-labelledby="more">
                          <div class="row">
                            <div class="row flex-grow">
                            <div class="col-md-12 col-lg-12 grid-margin stretch-card">
                              <div class="card card-rounded">
                                <div class="card-body card-rounded">
                                  <h4 class="card-title  card-title-dash">Updates</h4>
                                  <div class="list align-items-center border-bottom py-2">
                                    <div class="wrapper w-100">
                                      <p class="mb-2 fw-medium"> All items processed are currently live </p>
                                      <div class="d-flex justify-content-between align-items-center">
                                        <div class="d-flex align-items-center">
                                          <i class="mdi mdi-calendar text-muted me-1"></i>
                                          <p class="mb-0 text-small text-muted">September 4, 2024</p>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="list align-items-center border-bottom py-2">
                                    <div class="wrapper w-100">
                                      <p class="mb-2 fw-medium"> Master Cartons Recieved </p>
                                      <div class="d-flex justify-content-between align-items-center">
                                        <div class="d-flex align-items-center">
                                          <i class="mdi mdi-calendar text-muted me-1"></i>
                                          <p class="mb-0 text-small text-muted">September 9, 2024</p>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="list align-items-center border-bottom py-2">
                                    <div class="wrapper w-100">
                                      <p class="mb-2 fw-medium"> Portal Overview Meeting </p>
                                      <div class="d-flex justify-content-between align-items-center">
                                        <div class="d-flex align-items-center">
                                          <i class="mdi mdi-calendar text-muted me-1"></i>
                                          <p class="mb-0 text-small text-muted">September 13, 2024</p>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                  
                                  
                                </div>
                              </div>
                            </div>
                            
                          </div>
                          </div>
                        </div>
                
                 
                
                
                
                
                
                
                
                
                
                
                </div>
              </div>
            </div>
            <!-- content-wrapper ends -->
           
          </div>
          <!-- main-panel ends -->
        </div>
        <!-- page-body-wrapper ends -->
      </div>
      <!-- container-scroller -->

      <?php require("../imports/importjs.php") ?>

</body>

</html>